unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, ValEdit, StdCtrls, ComCtrls, Formula;

type
  TForm4 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    memHelp: TMemo;
    edtExpression: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    btnParse: TButton;
    ValueListEditor1: TValueListEditor;
    btnEvaluate: TButton;
    edtResult: TEdit;
    Label3: TLabel;
    cbFormat: TComboBox;
    btnClearVars: TButton;
    Label4: TLabel;
    edtResultVar: TEdit;
    btnCompare: TButton;
    TabSheet3: TTabSheet;
    memLog: TMemo;
    procedure btnClearVarsClick(Sender: TObject);
    procedure btnCompareClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnParseClick(Sender: TObject);
    procedure btnEvaluateClick(Sender: TObject);
    procedure cbFormatChange(Sender: TObject);
    procedure edtExpressionChange(Sender: TObject);
  private
    fFormula: tExpression;
    fEvaluated: Boolean;
    procedure SetEvaluated(aValue: Boolean);
  public
  end;

var
  Form4: TForm4;

implementation

uses
  TypInfo,
  StreamSec.DSI.Arith.OO;

{$R *.dfm}

procedure TForm4.btnClearVarsClick(Sender: TObject);
begin
  ValueListEditor1.Strings.Clear;
end;

procedure TForm4.btnCompareClick(Sender: TObject);
begin
  if ValueListEditor1.Strings.Count > 0 then begin
    fFormula.SetVariables(ValueListEditor1.Strings);
  end;
  if tDSIntRec(edtResult.Text) = fFormula.Evaluate then
    ShowMessage('Same')
  else if tDSIntRec(edtResult.Text) > fFormula.Evaluate then
    ShowMessage('Expression less than old value')
  else
    ShowMessage('Expression greater than old value')
end;

procedure TForm4.btnEvaluateClick(Sender: TObject);
begin
  if ValueListEditor1.Strings.Count > 0 then begin
    fFormula.SetVariables(ValueListEditor1.Strings);
  end;
  edtResult.Text := string(fFormula.Evaluate);
  if edtResultVar.Text <> '' then begin
    ValueListEditor1.Values[edtResultVar.Text] := edtResult.Text;
    memLog.Lines.Add(edtResultVar.Text + ' := ' + edtExpression.Text + ';');
  end else begin
    memLog.Lines.Add(edtExpression.Text);
  end;
  memLog.Lines.Add(edtResult.Text);

  edtResultVar.Text := '';
  SetEvaluated(True);
end;

procedure TForm4.btnParseClick(Sender: TObject);
var
  lSL: TStringList;
  lIdx, lDummy: Integer;
begin
  FreeAndNil(fFormula);
  fFormula := tExpression.Create(edtExpression.Text);
  lSL := TStringList.Create;
  try
    fFormula.GetVariableNames(lSL);
    for lIdx := 0 to lSL.Count - 1 do
      if not ValueListEditor1.FindRow(lSL[lIdx],lDummy) then
        ValueListEditor1.Values[lSL[lIdx]] := '';
  finally
    lSL.Free;
  end;
  SetEvaluated(False);
  if edtResult.Text <> '' then
    btnCompare.Enabled := True;
end;

procedure TForm4.cbFormatChange(Sender: TObject);
begin
  tDSIntRec.fStringFormat := tMPStringFormat(cbFormat.ItemIndex);
  if fEvaluated then
    edtResult.Text := string(fFormula.Evaluate);
end;

procedure TForm4.edtExpressionChange(Sender: TObject);
begin
  fFormula.Free;
  fFormula := nil;
  SetEvaluated(False);
end;

procedure TForm4.FormCreate(Sender: TObject);
var
  lFormat: tMPStringFormat;
begin
  memHelp.Clear;
  with memHelp.Lines do begin
    Add('USAGE');
    Add('');
    Add('1. Enter a formula');
    Add('2. Press Update to parse the formula and identify the variables');
    Add('3. Enter the variable values');
    Add('4. Press Evaluate to calculate the function value');
    Add('');
    Add('NUMBER FORMATS');
    Add('');
    Add('Each value has to be entered on the format [PREFIX][''-'']DIGITS.');
    Add('The prefix must be absent unless the Auto Format setting is selected');
    Add('');
    Add('OPERATORS');
    Add('');
    Add('+'#9'Addition');
    Add('-'#9'Subtraction');
    Add('*'#9'Multiplication');
    Add('\'#9'Integer division');
    Add('<'#9'Shift left');
    Add('>'#9'Shift right');
    Add('|'#9'Modulus. The result is an element in the corresponding finite field. All subsequent operations on the result will be performed in the finite field');
    Add('%'#9'Integer division residue. Same as | except that the result is an element of the set of integers');
    Add('/'#9'Modular division. The result is the left operand times the inverse of the right operand. At least one operand must be an element of a finite field. The other operand must be either an integer or an element of the same field');
    Add('^'#9'Modular exponentiation. The left operand must be an element of a finite field. The right operand is the exponent');
    Add('');
    Add('FUNCTIONS');
    Add('');
    Add('GCF(x,y)'#9'Greatest common factor of x and y');
    Add('LCM(x,y)'#9'Least common multiple of x and y, i.e. xy/GCD(x,y)');
    Add('Random(k)'#9'A k-bit random number. A random number less than 2^k and greater than or equal to 2^(k-1))');
    Add('Prime(k)'#9'A k-bit random prime');
    Add('MSB(x)'#9'The most significant bit of x');
  end;
  cbFormat.Clear;
  for lFormat := Low(lFormat) to High(lFormat) do
    cbFormat.Items.Add(GetEnumName(TypeInfo(tMpStringFormat),Ord(lFormat)));
  cbFormat.ItemIndex := Ord(tDSIntRec.fStringFormat);
end;

procedure TForm4.SetEvaluated(aValue: Boolean);
begin
  fEvaluated := aValue;
  if not aValue then begin
    btnEvaluate.Enabled := Assigned(fFormula)
  end else begin
    btnEvaluate.Enabled := False;
  end;
end;

end.
